import numpy as np
import matplotlib
matplotlib.use('TkAgg')
import matplotlib.pyplot as plt
import torch
import sys

import argparse

from scipy.stats import norm





isiorg_snr10 = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.200052000520005e-05, 0.001086010860108601, 0.00880308803088031, 0.03275232752327523, 0.07645076450764508, 0.12926929269292692]
isiorg_snr12 =[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.200052000520005e-05, 0.0010820108201082012, 0.008822088220882209, 0.03282032820328203, 0.07654076540765407, 0.12941129411294114]
isiorg_snr14 = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.200052000520005e-05, 0.001084010840108401, 0.008837088370883709, 0.03285532855328553, 0.07658576585765858, 0.12948129481294812]
isiorg_snr16 = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.200052000520005e-05, 0.001086010860108601, 0.008839088390883909, 0.03287532875328753, 0.07661076610766107, 0.12951729517295174]
isiorg_snr18 = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.200052000520005e-05, 0.001087010870108701, 0.008843088430884308, 0.03288832888328883, 0.07661876618766188, 0.12953629536295364]
isiorg_snr20 = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.200052000520005e-05, 0.001087010870108701, 0.00884508845088451, 0.032891328913289136, 0.07662576625766257, 0.13015430154301544]
isiorg_snr22 = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.200052000520005e-05, 0.001087010870108701, 0.00884508845088451, 0.03289732897328973, 0.07753377533775338, 0.14672246722467225]
isiorg_snr24 = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.200052000520005e-05, 0.001087010870108701, 0.008853088530885308, 0.034547345473454734, 0.1028510285102851, 0.23206432064320642]
isiorg_snr26 = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.200052000520005e-05, 0.001115011150111501, 0.011655116551165511, 0.07584875848758488, 0.22824828248282483, 0.3735687356873569]
isiorg_snr28 = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.200052000520005e-05, 0.001086010860108601, 0.008839088390883909, 0.03287532875328753, 0.07661076610766107, 0.12951729517295174]
isiorg_snr30 = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.9000290002900027e-05, 0.005525055250552506, 0.08022880228802289, 0.2720507205072051, 0.4267742677426774, 0.4827608276082761, 0.49596495964959647]
isiorg_snr8 = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.100051000510005e-05, 0.0010890108901089011, 0.008805088050880509, 0.03265932659326593, 0.07626276262762628, 0.12904029040290402]
isiorg_default = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.200052000520005e-05, 0.001086010860108601, 0.008805088050880509, 0.03259832598325983, 0.07577075770757707, 0.12774727747277473]




snr30_2 = np.arange(30,0,-2)
plt.figure("fwdbwd")
plt.xlabel('SNR (dB)',fontsize=13)
plt.xticks(fontsize=13)
plt.ylabel('BER ',fontsize=13)
#plt.ylim([0.8,10])
plt.yscale('log')
plt.grid(True)
	
plt.plot(snr30_2, isiorg_snr30, label=30)
plt.plot(snr30_2, isiorg_snr28, label=28)
plt.plot(snr30_2, isiorg_snr26, label=26)
plt.plot(snr30_2, isiorg_snr24, label=24)
plt.plot(snr30_2, isiorg_snr22, label=22)
plt.plot(snr30_2, isiorg_snr20, label=20)
plt.plot(snr30_2, isiorg_snr18, label=18)
plt.plot(snr30_2, isiorg_snr16, label=16)
plt.plot(snr30_2, isiorg_snr14, label=14)
plt.plot(snr30_2, isiorg_snr12, label=12)
plt.plot(snr30_2, isiorg_snr10, label=10)
plt.plot(snr30_2, isiorg_snr8, label=8)
plt.plot(snr30_2, isiorg_default, label='default')

plt.legend(loc='best')


plt.show()
